typedef struct {
    unsigned char  osize_lo;   // original size lowbyte
    unsigned char  osize_hi;   // original size highbyte
    unsigned char  magic1;     // must be equal to TTUNPACK_MAGIC1
    unsigned char  magic2;     // must be equal to TTUNPACK_MAGIC2
    unsigned char  csize_lo;   // compressed size lowbyte
    unsigned char  csize_hi;   // compressed size lowbyte
    unsigned char  esc1;       // escape >> (8-escBits)
    unsigned char  notused3;
    unsigned char  notused4;
    unsigned char  esc2;       // escBits
    unsigned char  gamma1;     // maxGamma + 1
    unsigned char  gamma2;     // (1<<maxGamma)
    unsigned char  extralz;    // extraLZPosBits
    unsigned char  notused1;
    unsigned char  notused2;
    unsigned char  rleentries; // rleUsed
} TTUNPACK_HEADER;

#define TTUNPACK_MAGIC1 0x54
#define TTUNPACK_MAGIC2 0x50

#define ttunpack_size(_p_)  ((unsigned short)(((TTUNPACK_HEADER*)(_p_))->osize_lo | (((TTUNPACK_HEADER*)(_p_))->osize_hi << 8)))
#define ttunpack_valid(_p_) (((TTUNPACK_HEADER*)(_p_))->magic1 == TTUNPACK_MAGIC1 && ((TTUNPACK_HEADER*)(_p_))->magic2 == TTUNPACK_MAGIC2)

#define TTUNPACK_OKAY             0
#define TTUNPACK_NOESCFOUND     248
#define TTUNPACK_ESCBITS        249
#define TTUNPACK_MAXGAMMA       250
#define TTUNPACK_EXTRALZP       251
#define TTUNPACK_NOMAGIC        252
#define TTUNPACK_OUTBUFOVERRUN  253
#define TTUNPACK_LZPOSUNDERRUN  254

#define ttunpack_decompress ((unsigned short(*)(unsigned char*,unsigned char*))__ttunpack_decompress)
unsigned short __ttunpack_decompress[] = {
0x48e7,0x7ffa,0x4fef,0xffe8,0x206f,0x0050,0x0c28,0x0054,0x0002,0x6608,
0x0c28,0x0050,0x0003,0x6708,0x303c,0x00fc,0x6000,0x0264,0x4286,0x1c28,
0x0006,0x4247,0x1e28,0x0009,0x4245,0x1a28,0x000a,0x5345,0x4240,0x1028,
0x000c,0x3c40,0x7201,0xeb69,0x3f41,0x000e,0x7002,0xeb68,0x3f40,0x000c,
0x7208,0x9245,0x3f41,0x000a,0x7008,0x9047,0x3840,0x303c,0x00f9,0x0c47,
0x0008,0x6200,0x021e,0x4240,0x1028,0x000b,0xb06f,0x000e,0x660c,0x0c45,
0x0004,0x6306,0x0c45,0x0007,0x6308,0x303c,0x00fa,0x6000,0x01fe,0x7204,
0xb24e,0x6408,0x303c,0x00fb,0x6000,0x01f0,0x43e8,0x000f,0x2f49,0x0010,
0x266f,0x0054,0x43fa,0x01ea,0x2f49,0x0006,0x226f,0x0010,0x4280,0x1011,
0x41f0,0x0810,0x226f,0x0006,0x2288,0x41fa,0x01d4,0x2f48,0x0002,0x30bc,
0x0080,0x3606,0x4a47,0x670c,0x3f07,0x41fa,0x0274,0x4e90,0x3600,0x548f,
0x3043,0xbc88,0x6600,0x018c,0x3f05,0x45fa,0x021a,0x4e92,0x3800,0x426f,
0x0002,0x548f,0x0c44,0x0001,0x6754,0x3f05,0x4e92,0x3600,0x5343,0x302f,
0x000e,0x5540,0x548f,0xb043,0x6618,0x0c44,0x0003,0x6300,0x0170,0x45fa,
0x017e,0x4e92,0x3f40,0x0000,0x4e92,0x6000,0x0120,0x300e,0x6710,0x3f0e,
0x41fa,0x021a,0x4e90,0x320e,0xe36b,0x8640,0x548f,0x41fa,0x015a,0x4e90,
0x0a40,0x00ff,0x3203,0xe149,0x8240,0x6000,0x00fe,0x226f,0x0006,0x2051,
0x4240,0x1010,0x206f,0x0002,0x3210,0xc041,0x6700,0x00ca,0xe219,0x6402,
0x5291,0x3081,0x2051,0x4240,0x1010,0xc041,0x6630,0x3001,0xe218,0x6402,
0x5291,0x226f,0x0002,0x3280,0x3f07,0x45fa,0x01c0,0x4e92,0x3600,0x3f0c,
0x4e92,0x320c,0x48c1,0xe3ae,0x8c00,0x16c6,0x4286,0x3c03,0x588f,0x6000,
0xff26,0x3001,0xe218,0x6402,0x5291,0x206f,0x0002,0x3080,0x3f05,0x4e92,
0x3600,0x548f,0xb66f,0x000e,0x6522,0x3f2f,0x000a,0x41fa,0x0180,0x4e90,
0x966f,0x0010,0x322f,0x000c,0xe36b,0x8640,0x3f05,0x4e92,0x5340,0xe148,
0x8640,0x588f,0x3f05,0x4e92,0x3800,0x548f,0x0c44,0x001f,0x6210,0x4280,
0x3004,0x206f,0x0010,0x1230,0x0800,0x4881,0x6016,0x3f3c,0x0003,0x41fa,
0x0140,0x4e90,0x3204,0x0641,0xffe0,0xe749,0x8240,0x548f,0x4242,0xb642,
0x6500,0xfeac,0x16c1,0x5242,0xb642,0x64f8,0x6000,0xfea0,0x3001,0x226f,
0x0006,0xe218,0x6402,0x5291,0x206f,0x0002,0x3080,0x41fa,0x0056,0x4e90,
0x3200,0x0a41,0x00ff,0x4242,0xb842,0x6500,0xfe7a,0x4280,0x3001,0x204b,
0x91c0,0x102f,0x0001,0xd028,0xffff,0x16c0,0x5242,0xb842,0x64e8,0x6000,
0xfe5e,0x3f0c,0x41fa,0x00d6,0x4e90,0x320c,0xe36b,0x8600,0x16c3,0x548f,
0x6000,0xfe48,0x4240,0x4fef,0x0018,0x4cdf,0x5ffe,0x4e75,0x0000,0x0000,
0x0000,0x41fa,0xfff8,0x2250,0x4240,0x1019,0x2089,0x323a,0xfff0,0x0c01,
0x0080,0x6602,0x4e75,0xe148,0x1011,0x0c01,0x0008,0x6212,0x6630,0x0240,
0x0fff,0xe848,0x4e75,0x0240,0x7fff,0xee48,0x4e75,0x0c01,0x0020,0x62f2,
0x6508,0x0240,0x3fff,0xec48,0x4e75,0x0240,0x1fff,0xea48,0x4e75,0x0240,
0x07ff,0xe648,0x4e75,0x0c01,0x0002,0x62f2,0x6608,0x0240,0x03ff,0xe448,
0x4e75,0x0240,0x01ff,0xe248,0x4e75,0x2f03,0x4281,0x302f,0x0008,0x207a,
0xff84,0x343a,0xff84,0xb041,0x6312,0x3602,0xc610,0xe21a,0x6402,0x5288,
0x4a03,0x6704,0x5241,0x60ea,0x2608,0x41fa,0xff64,0x2083,0x41fa,0xff62,
0x3082,0x2043,0x7601,0xe36b,0x3f01,0x6108,0x544f,0x8043,0x261f,0x4e75,
0x4240,0x322f,0x0004,0x6730,0x207a,0xff3e,0x2243,0x343a,0xff3c,0x5341,
0xe348,0x3602,0xc610,0x6702,0x5200,0xe21a,0x6402,0x5288,0x51c9,0xffee,
0x2609,0x43fa,0xff20,0x3282,0x43fa,0xff16,0x2288,0x2243,0x4e75};
